/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.trainer;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.actor.AIBattleActor;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.battle.battleactor.EntityBackedTrainerBattleActor;
import kiwiapollo.cobblemontrainerbattle.battle.battleactor.PlayerBackedTrainerBattleActor;
import kiwiapollo.cobblemontrainerbattle.battle.battleactor.SafeCopyBattlePokemonFactory;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.player.PlayerBattleParticipant;
import kiwiapollo.cobblemontrainerbattle.battle.battleparticipant.trainer.AbstractTrainerBattleParticipant;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.CooldownElapsedPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.ForbiddenAbilityPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.ForbiddenHeldItemPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.ForbiddenLabelPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.ForbiddenMovePredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.ForbiddenPokemonPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MaximumPartyLevelPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MaximumPartySizePredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MessagePredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MinimumPartyLevelPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.MinimumPartySizePredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.RematchAllowedPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.RequiredAbilityPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.RequiredHeldItemPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.RequiredLabelPredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.RequiredMovePredicate;
import kiwiapollo.cobblemontrainerbattle.battle.predicate.RequiredPokemonPredicate;
import kiwiapollo.cobblemontrainerbattle.common.LevelMode;
import kiwiapollo.cobblemontrainerbattle.exception.PokemonParseException;
import kiwiapollo.cobblemontrainerbattle.global.preset.TrainerPreset;
import kiwiapollo.cobblemontrainerbattle.pokemon.RelativeLevelShowdownPokemonParser;
import kiwiapollo.cobblemontrainerbattle.pokemon.ShowdownPokemon;
import net.minecraft.class_3222;

public class RelativeLevelTrainer
extends AbstractTrainerBattleParticipant {
    private final List<MessagePredicate<PlayerBattleParticipant>> predicates;

    public RelativeLevelTrainer(String id, TrainerPreset preset, List<ShowdownPokemon> team) {
        super(id, preset, RelativeLevelTrainer.toPartyStore(team));
        this.predicates = List.of(new RematchAllowedPredicate(id, preset.isRematchAllowed), new CooldownElapsedPredicate(id, preset.cooldownInSeconds), new MaximumPartySizePredicate.PlayerPredicate(preset.maximumPartySize), new MinimumPartySizePredicate.PlayerPredicate(preset.minimumPartySize), new MaximumPartyLevelPredicate(preset.maximumPartyLevel), new MinimumPartyLevelPredicate(preset.minimumPartyLevel), new RequiredLabelPredicate(preset.requiredLabel), new RequiredPokemonPredicate(preset.requiredPokemon), new RequiredHeldItemPredicate(preset.requiredHeldItem), new RequiredAbilityPredicate(preset.requiredAbility), new RequiredMovePredicate(preset.requiredMove), new ForbiddenLabelPredicate(preset.forbiddenLabel), new ForbiddenPokemonPredicate(preset.forbiddenPokemon), new ForbiddenHeldItemPredicate(preset.forbiddenHeldItem), new ForbiddenAbilityPredicate(preset.forbiddenAbility), new ForbiddenMovePredicate(preset.forbiddenMove));
    }

    private static PartyStore toPartyStore(List<ShowdownPokemon> team) {
        PartyStore party = new PartyStore(UUID.randomUUID());
        for (ShowdownPokemon showdownPokemon : team) {
            try {
                party.add(new RelativeLevelShowdownPokemonParser().toCobblemonPokemon(showdownPokemon));
            }
            catch (PokemonParseException pokemonParseException) {}
        }
        return party;
    }

    @Override
    public List<MessagePredicate<PlayerBattleParticipant>> getPredicates() {
        return this.predicates;
    }

    @Override
    public LevelMode getLevelMode() {
        return LevelMode.NORMAL;
    }

    @Override
    public AIBattleActor createBattleActor(class_3222 player) {
        try {
            return new EntityBackedTrainerBattleActor(this.getName(), this.getUuid(), this.getBattleTeam(player), this.getBattleAI(), this.getNearAttachedLivingEntity(player));
        }
        catch (ClassCastException | NullPointerException e) {
            return new PlayerBackedTrainerBattleActor(this.getName(), this.getUuid(), this.getBattleTeam(player), this.getBattleAI(), player);
        }
    }

    @Override
    public List<BattlePokemon> getBattleTeam(class_3222 player) {
        int pivot = this.getMaximumPlayerLevel(player);
        ArrayList<BattlePokemon> team = new ArrayList<BattlePokemon>();
        this.getParty().forEach(pokemon -> {
            Pokemon clone = pokemon.clone(true, null);
            clone.setLevel(this.toAbsoluteLevel(pivot, this.toRelativeLevel(pokemon.getLevel())));
            team.add(new SafeCopyBattlePokemonFactory().apply(clone));
        });
        team.forEach(pokemon -> pokemon.getEffectedPokemon().heal());
        return team;
    }

    private int toAbsoluteLevel(int pivot, int relativeLevel) {
        return pivot + relativeLevel;
    }

    private int toRelativeLevel(int level) {
        return level - 50;
    }

    private int getMaximumPlayerLevel(class_3222 player) {
        return Cobblemon.INSTANCE.getStorage().getParty(player).toGappyList().stream().filter(Objects::nonNull).map(Pokemon::getLevel).max(Integer::compare).orElseThrow();
    }
}

